<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\models\LoginForm;
use app\models\User;

class SiteController extends Controller
{
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionIndex()
    {
        return $this->render('index');
    }

    public function actionRegister()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new User();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Регистрация успешна!');
            Yii::$app->user->login($model, 3600*24*30);
            return $this->goHome();
        }

        return $this->render('register', [
            'model' => $model,
        ]);
    }

    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();

        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            Yii::$app->session->setFlash('success', 'Добро пожаловать!');
            return $this->goBack();
        }

        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        Yii::$app->session->setFlash('success', 'Вы вышли из системы');
        return $this->goHome();
    }

    public function actionProfile()
    {
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['login']);
        }

        return $this->render('profile', [
            'user' => Yii::$app->user->identity,
        ]);
    }

    public function actionCatalog()
{
    $games = \app\models\Game::find()
        ->orderBy(['category' => SORT_ASC, 'name' => SORT_ASC])
        ->all();
    
    $categories = \app\models\Game::find()
        ->select('category')
        ->distinct()
        ->orderBy('category')
        ->column();
    
    return $this->render('catalog', [
        'games' => $games,
        'categories' => $categories,
    ]);
}

/**
 * Мои заявки
 */
public function actionMyRequests()
{
    if (Yii::$app->user->isGuest) {
        return $this->redirect(['login']);
    }

    $user = Yii::$app->user->identity;
    
    $requests = \app\models\Request::find()
        ->with(['session.game'])
        ->where(['user_id' => $user->id])
        ->orderBy(['created_at' => SORT_DESC])
        ->all();
    
    return $this->render('my-requests', [
        'requests' => $requests,
    ]);
}

/**
 * Создание заявки
 */
public function actionCreateRequest($session_id = null)
{
    if (Yii::$app->user->isGuest) {
        return $this->redirect(['login']);
    }

    $model = new \app\models\Request();
    $user = Yii::$app->user->identity;
    
    // Получаем доступные игровые сессии
    $sessions = \app\models\GameSession::find()
        ->with('game')
        ->where(['>=', 'date', date('Y-m-d')])
        ->andWhere(['status' => 'planned'])
        ->andWhere('current_players < max_players')
        ->orderBy(['date' => SORT_ASC, 'time' => SORT_ASC])
        ->all();
    
    if ($model->load(Yii::$app->request->post())) {
        $model->user_id = $user->id;
        $model->consent_data = 1;
        
        // Получаем сессию для расчета цены
        $session = \app\models\GameSession::findOne($model->session_id);
        if ($session) {
            $model->total_price = $session->price * $model->player_count;
        }
        
        if ($model->save()) {
            Yii::$app->session->setFlash('success', 'Заявка успешно создана! Ждите подтверждения от администратора.');
            return $this->redirect(['my-requests']);
        }
    }
    
    // Если передан ID сессии, предзаполняем
    if ($session_id) {
        $model->session_id = $session_id;
    }
    
    return $this->render('create-request', [
        'model' => $model,
        'sessions' => $sessions,
        'user' => $user,
    ]);
}

/**
 * Расписание игр
 */
public function actionSchedule()
{
    $sessions = \app\models\GameSession::find()
        ->with('game')
        ->where(['>=', 'date', date('Y-m-d')])
        ->andWhere(['status' => 'planned'])
        ->orderBy(['date' => SORT_ASC, 'time' => SORT_ASC])
        ->all();
    
    return $this->render('schedule', [
        'sessions' => $sessions,
    ]);
}
}