<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%requests}}`.
 */
class m260212_160927_create_requests_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%requests}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'session_id' => $this->integer()->notNull(),
            'payment_method' => "ENUM('наличными', 'картой', 'переводом') NOT NULL",
            'status' => "ENUM('новая', 'одобрена', 'завершена', 'отменена') NOT NULL DEFAULT 'новая'",
            'player_count' => $this->integer()->notNull()->defaultValue(1),
            'total_price' => $this->decimal(10, 2)->notNull(),
            'consent_data' => $this->boolean()->notNull()->defaultValue(false),
            'admin_comment' => $this->text(),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ], 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB');

        $this->addForeignKey(
            'fk-requests-user_id',
            '{{%requests}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-requests-session_id',
            '{{%requests}}',
            'session_id',
            '{{%game_sessions}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->createIndex('idx-requests-status', '{{%requests}}', 'status');
        $this->createIndex('idx-requests-user_id', '{{%requests}}', 'user_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%requests}}');
    }
}
