<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%insert_games}}`.
 */
class m260212_161243_create_insert_games_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $games = [
            // Классические
            ['Шахматы', 'классические', 'Классическая стратегическая игра', 2, 2, 60, true],
            ['Шашки', 'классические', 'Логическая игра на доске', 2, 2, 45, false],
            ['Нарды', 'классические', 'Игра на удачу и стратегию', 2, 2, 30, false],
            ['Домино', 'классические', 'Игра с костяшками', 2, 4, 30, false],
            
            // Карточные
            ['Шакал', 'карточные', 'Пиратская карточная игра', 2, 6, 45, true],
            ['Тако, кот, коза, сыр, пицца', 'карточные', 'Быстрая карточная игра на реакцию', 2, 8, 20, true],
            ['Взрывные котята', 'карточные', 'Русская рулетка с котиками', 2, 5, 30, false],
            ['Свинтус', 'карточные', 'Веселая карточная игра', 2, 8, 30, false],
            ['Мафия', 'карточные', 'Психологическая игра', 6, 12, 60, true],
            ['Бункер', 'карточные', 'Постапокалиптическая игра', 4, 12, 45, false],
            ['Сопротивление', 'карточные', 'Социальная дедуктивная игра', 5, 10, 40, false],
            
            // Экономические
            ['Монополия', 'экономические', 'Классическая экономическая игра', 2, 8, 120, true],
            ['Крысиные бега', 'экономические', 'Игра про крысиные гонки', 2, 6, 60, false],
            ['Маракайбо', 'экономические', 'Пиратская экономическая игра', 2, 4, 90, false],
            
            // Стратегии
            ['Каркассон', 'стратегии', 'Средневековая стратегия', 2, 5, 45, true],
            ['Улей', 'стратегии', 'Стратегия без доски', 2, 2, 30, false],
            ['Битва за Рокуган', 'стратегии', 'Тактическая игра', 2, 4, 60, false],
            ['Иван Грозный: Первый царь', 'стратегии', 'Русская историческая стратегия', 2, 4, 90, false],
            
            // Для детей
            ['Кубопрыги', 'для детей', 'Активная игра с кубиками', 2, 6, 20, false],
            ['Фотовечеринка', 'для детей', 'Игра про фотографии', 2, 8, 30, false],
            ['Средневековая академия', 'для детей', 'Образовательная игра', 2, 4, 40, false],
        ];

        $time = time();
        foreach ($games as $game) {
            $this->insert('{{%games}}', [
                'name' => $game[0],
                'category' => $game[1],
                'description' => $game[2],
                'min_players' => $game[3],
                'max_players' => $game[4],
                'duration' => $game[5],
                'is_popular' => $game[6],
                'created_at' => $time,
                'updated_at' => $time,
            ]);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%insert_games}}');
    }
}
