<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * Модель для таблицы "subscribers"
 *
 * @property int $id
 * @property string $email
 * @property int $is_active
 * @property int $created_at
 * @property int $updated_at
 */
class Subscriber extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%subscribers}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['email'], 'required', 'message' => 'Введите email адрес'],
            [['email'], 'email', 'message' => 'Введите корректный email адрес'],
            [['email'], 'unique', 'message' => 'Этот email уже подписан на рассылку'],
            [['is_active'], 'integer'],
            [['email'], 'string', 'max' => 255],
            ['is_active', 'default', 'value' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'email' => 'Email',
            'is_active' => 'Активна',
            'created_at' => 'Дата подписки',
            'updated_at' => 'Дата обновления',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($this->isNewRecord) {
                $this->created_at = time();
            }
            $this->updated_at = time();
            return true;
        }
        return false;
    }

    /**
     * Отписаться от рассылки
     */
    public function unsubscribe()
    {
        $this->is_active = false;
        return $this->save();
    }

    /**
     * Подписаться на рассылку
     */
    public function subscribe()
    {
        $this->is_active = true;
        return $this->save();
    }

    /**
     * Получить активных подписчиков
     */
    public static function getActiveSubscribers()
    {
        return self::find()
            ->where(['is_active' => true])
            ->orderBy(['created_at' => SORT_DESC])
            ->all();
    }
}