<?php

/** @var yii\web\View $this */

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-index">
    <h1><?= $this->title ?></h1>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3><?= $totalUsers ?></h3>
                <p>Пользователей</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-gamepad"></i>
            </div>
            <div class="stat-content">
                <h3><?= $totalGames ?></h3>
                <p>Игр</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-ticket-alt"></i>
            </div>
            <div class="stat-content">
                <h3><?= $totalRequests ?></h3>
                <p>Всего заявок</p>
            </div>
        </div>
        
        <div class="stat-card highlight">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3><?= $newRequests ?></h3>
                <p>Новых заявок</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar"></i>
            </div>
            <div class="stat-content">
                <h3><?= $totalSessions ?></h3>
                <p>Ближайших игр</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-star"></i>
            </div>
            <div class="stat-content">
                <h3><?= $totalReviews ?></h3>
                <p>Отзывов</p>
            </div>
        </div>
    </div>
    
    <div class="admin-menu">
        <h2>Управление</h2>
        
        <div class="menu-grid">
            <a href="<?= \yii\helpers\Url::to(['admin/requests']) ?>" class="menu-item">
                <i class="fas fa-ticket-alt"></i>
                <span>Заявки</span>
                <?php if ($newRequests > 0): ?>
                    <span class="badge"><?= $newRequests ?></span>
                <?php endif; ?>
            </a>
            
            <a href="<?= \yii\helpers\Url::to(['admin/users']) ?>" class="menu-item">
                <i class="fas fa-users"></i>
                <span>Пользователи</span>
            </a>
            
            <a href="<?= \yii\helpers\Url::to(['admin/games']) ?>" class="menu-item">
                <i class="fas fa-gamepad"></i>
                <span>Игры</span>
            </a>
            
            <a href="<?= \yii\helpers\Url::to(['admin/sessions']) ?>" class="menu-item">
                <i class="fas fa-calendar"></i>
                <span>Расписание</span>
            </a>
            
            <a href="<?= \yii\helpers\Url::to(['admin/reviews']) ?>" class="menu-item">
                <i class="fas fa-star"></i>
                <span>Отзывы</span>
            </a>
            
            <a href="<?= \yii\helpers\Url::to(['admin/stats']) ?>" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Статистика</span>
            </a>
        </div>
    </div>
</div>

<style>
.admin-index {
    padding: 20px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 40px;
}

.stat-card {
    background: white;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    display: flex;
    align-items: center;
    transition: transform 0.3s;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.stat-card.highlight {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.stat-icon {
    font-size: 40px;
    margin-right: 20px;
    color: #667eea;
}

.stat-card.highlight .stat-icon {
    color: white;
}

.stat-content h3 {
    font-size: 32px;
    margin: 0;
    font-weight: 700;
}

.stat-content p {
    margin: 5px 0 0;
    color: #666;
}

.stat-card.highlight .stat-content p {
    color: rgba(255,255,255,0.9);
}

.admin-menu h2 {
    margin-bottom: 20px;
    color: #333;
}

.menu-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
}

.menu-item {
    background: white;
    border-radius: 10px;
    padding: 30px 20px;
    text-align: center;
    text-decoration: none;
    color: #333;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: all 0.3s;
    position: relative;
}

.menu-item:hover {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    transform: translateY(-5px);
}

.menu-item i {
    font-size: 40px;
    margin-bottom: 15px;
    display: block;
    color: #667eea;
}

.menu-item:hover i {
    color: white;
}

.menu-item span {
    font-size: 16px;
    font-weight: 600;
}

.badge {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #f44336;
    color: white;
    border-radius: 20px;
    padding: 5px 10px;
    font-size: 12px;
    font-weight: 600;
}

@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .menu-grid {
        grid-template-columns: 1fr;
    }
}
</style>