<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Каталог настольных игр';
?>

<div class="catalog-page">
    <!-- Хедер каталога -->
    <div class="catalog-header">
        <div class="container">
            <h1 class="catalog-title">Каталог настольных игр</h1>
            <p class="catalog-subtitle">Выберите игру по душе и присоединяйтесь к игровой сессии</p>
        </div>
    </div>

    <div class="container">
        <div class="catalog-grid">
            <!-- Боковая панель с категориями -->
            <aside class="catalog-sidebar">
                <div class="categories-card">
                    <h3>Категории</h3>
                    <ul class="categories-list">
                        <li class="active">
                            <a href="<?= Url::to(['catalog']) ?>">
                                Все игры
                                <span class="count"><?= count($games) ?></span>
                            </a>
                        </li>
                        <?php foreach ($categories as $category): ?>
                            <?php
                            $count = \app\models\Game::find()->where(['category' => $category])->count();
                            $categoryNames = [
                                'классические' => 'Классические',
                                'карточные' => 'Карточные',
                                'экономические' => 'Экономические',
                                'стратегии' => 'Стратегии',
                                'для детей' => 'Для детей',
                            ];
                            ?>
                            <li>
                                <a href="#<?= $category ?>">
                                    <?= $categoryNames[$category] ?? $category ?>
                                    <span class="count"><?= $count ?></span>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                
                <div class="info-card">
                    <i class="fas fa-info-circle"></i>
                    <h4>Как записаться?</h4>
                    <p>Выберите игру, найдите удобное время в расписании и забронируйте места</p>
                    <?php if (Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['register']) ?>" class="btn btn-outline">
                            <i class="fas fa-user-plus"></i>
                            Зарегистрироваться
                        </a>
                    <?php endif; ?>
                </div>
            </aside>

            <!-- Список игр -->
            <div class="catalog-content">
                <?php foreach ($categories as $category): ?>
                    <?php
                    $categoryGames = \app\models\Game::find()
                        ->where(['category' => $category])
                        ->orderBy(['name' => SORT_ASC])
                        ->all();
                    
                    if (empty($categoryGames)) continue;
                    
                    $categoryNames = [
                        'классические' => 'Классические',
                        'карточные' => 'Карточные',
                        'экономические' => 'Экономические',
                        'стратегии' => 'Стратегии',
                        'для детей' => 'Для детей',
                    ];
                    ?>
                    
                    <section id="<?= $category ?>" class="category-section">
                        <div class="category-header">
                            <h2><?= $categoryNames[$category] ?? $category ?></h2>
                            <span class="category-count"><?= count($categoryGames) ?> игр</span>
                        </div>
                        
                        <div class="games-grid">
                            <?php foreach ($categoryGames as $game): ?>
                                <div class="game-card">
                                    <?php if ($game->is_popular): ?>
                                        <div class="game-badge">
                                            <i class="fas fa-crown"></i>
                                            Популярная
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="game-icon">
                                        <?php
                                        $icons = [
                                            'классические' => 'fa-chess-board',
                                            'карточные' => 'fa-club',
                                            'экономические' => 'fa-coins',
                                            'стратегии' => 'fa-chess-knight',
                                            'для детей' => 'fa-child',
                                        ];
                                        $icon = $icons[$category] ?? 'fa-dice';
                                        ?>
                                        <i class="fas <?= $icon ?>"></i>
                                    </div>
                                    
                                    <h3 class="game-title"><?= Html::encode($game->name) ?></h3>
                                    
                                    <div class="game-meta">
                                        <div class="meta-item">
                                            <i class="fas fa-users"></i>
                                            <?= $game->min_players ?>-<?= $game->max_players ?>
                                        </div>
                                        <div class="meta-item">
                                            <i class="fas fa-clock"></i>
                                            <?= $game->duration ?? 60 ?> мин
                                        </div>
                                    </div>
                                    
                                    <?php if ($game->description): ?>
                                        <p class="game-description"><?= Html::encode($game->description) ?></p>
                                    <?php endif; ?>
                                    
                                    <div class="game-actions">
                                        <a href="#" class="btn btn-primary" onclick="alert('Расписание игр появится позже')">
                                            <i class="fas fa-calendar-alt"></i>
                                            Расписание
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </section>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<style>
.catalog-page {
    padding-bottom: 60px;
}

.catalog-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 60px 0;
    margin-bottom: 40px;
    border-radius: 0 0 50px 50px;
    color: white;
    text-align: center;
}

.catalog-title {
    font-size: 42px;
    font-weight: 800;
    margin-bottom: 15px;
}

.catalog-subtitle {
    font-size: 18px;
    opacity: 0.95;
    max-width: 600px;
    margin: 0 auto;
}

.catalog-grid {
    display: grid;
    grid-template-columns: 300px 1fr;
    gap: 30px;
}

/* Sidebar */
.catalog-sidebar {
    position: sticky;
    top: 100px;
    align-self: start;
}

.categories-card,
.info-card {
    background: white;
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    margin-bottom: 20px;
}

.categories-card h3 {
    margin: 0 0 20px;
    font-size: 18px;
    color: #333;
    display: flex;
    align-items: center;
    gap: 10px;
}

.categories-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.categories-list li {
    margin-bottom: 10px;
}

.categories-list li a {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 15px;
    color: #666;
    text-decoration: none;
    border-radius: 10px;
    transition: all 0.3s;
}

.categories-list li a:hover {
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    color: #667eea;
}

.categories-list li.active a {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.categories-list .count {
    background: rgba(0,0,0,0.05);
    padding: 4px 10px;
    border-radius: 50px;
    font-size: 12px;
    font-weight: 600;
}

.categories-list li.active .count {
    background: rgba(255,255,255,0.2);
    color: white;
}

.info-card {
    text-align: center;
    background: linear-gradient(135deg, #667eea05 0%, #764ba205 100%);
}

.info-card i {
    font-size: 40px;
    color: #667eea;
    margin-bottom: 15px;
}

.info-card h4 {
    margin: 0 0 10px;
    color: #333;
}

.info-card p {
    color: #666;
    margin-bottom: 20px;
    font-size: 14px;
    line-height: 1.6;
}

.btn-outline {
    background: transparent;
    border: 2px solid #667eea;
    color: #667eea;
    padding: 10px 20px;
    border-radius: 50px;
    font-weight: 600;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    text-decoration: none;
}

.btn-outline:hover {
    background: #667eea;
    color: white;
}

/* Games Grid */
.category-section {
    margin-bottom: 50px;
}

.category-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.category-header h2 {
    font-size: 24px;
    color: #333;
    margin: 0;
}

.category-count {
    background: #f0f0f0;
    padding: 6px 15px;
    border-radius: 50px;
    font-size: 14px;
    color: #666;
}

.games-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 25px;
}

.game-card {
    background: white;
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    transition: all 0.3s;
    position: relative;
    display: flex;
    flex-direction: column;
}

.game-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
}

.game-badge {
    position: absolute;
    top: 15px;
    right: 15px;
    background: linear-gradient(135deg, #ffd700, #ffa500);
    color: white;
    padding: 6px 15px;
    border-radius: 50px;
    font-size: 12px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 6px;
    box-shadow: 0 5px 15px rgba(255, 215, 0, 0.3);
}

.game-icon {
    width: 70px;
    height: 70px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
}

.game-icon i {
    font-size: 30px;
    color: #667eea;
}

.game-title {
    font-size: 20px;
    font-weight: 700;
    color: #333;
    margin-bottom: 15px;
    line-height: 1.3;
}

.game-meta {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 6px;
    color: #666;
    font-size: 14px;
}

.meta-item i {
    color: #667eea;
}

.game-description {
    color: #666;
    font-size: 14px;
    line-height: 1.6;
    margin-bottom: 20px;
    flex: 1;
}

.game-actions {
    margin-top: auto;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s;
    border: none;
    cursor: pointer;
    width: 100%;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
}

/* Responsive */
@media (max-width: 992px) {
    .catalog-grid {
        grid-template-columns: 1fr;
    }
    
    .catalog-sidebar {
        position: static;
        margin-bottom: 30px;
    }
    
    .catalog-title {
        font-size: 32px;
    }
}

@media (max-width: 768px) {
    .catalog-header {
        padding: 40px 0;
    }
    
    .catalog-title {
        font-size: 28px;
    }
    
    .games-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .catalog-header {
        padding: 30px 0;
    }
    
    .catalog-title {
        font-size: 24px;
    }
    
    .catalog-subtitle {
        font-size: 16px;
    }
    
    .game-card {
        padding: 20px;
    }
}
</style>