<?php
use yii\helpers\Html;
use yii\helpers\Url;
use app\models\Request;
$this->title = 'Мои заявки';
?>

<div class="my-requests-page">
    <div class="requests-header">
        <div class="container">
            <h1 class="requests-title">Мои заявки</h1>
            <p class="requests-subtitle">История ваших бронирований на игры</p>
        </div>
    </div>

    <div class="container">
        <?php if (empty($requests)): ?>
            <!-- Пустое состояние -->
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="fas fa-ticket-alt"></i>
                </div>
                <h2>У вас пока нет заявок</h2>
                <p>Самое время выбрать игру и забронировать места!</p>
                <div class="empty-state-actions">
                    <a href="<?= Url::to(['site/catalog']) ?>" class="btn btn-primary">
                        <i class="fas fa-gamepad"></i>
                        Перейти в каталог
                    </a>
                    <a href="<?= Url::to(['site/schedule']) ?>" class="btn btn-outline">
                        <i class="fas fa-calendar-alt"></i>
                        Смотреть расписание
                    </a>
                </div>
            </div>
        <?php else: ?>
            <!-- Список заявок -->
            <div class="requests-timeline">
                <?php foreach ($requests as $request): ?>
                    <div class="request-card <?= $request->status ?>">
                        <div class="request-card-header">
                            <div class="request-game-info">
                                <div class="game-icon">
                                    <i class="fas fa-dice-d20"></i>
                                </div>
                                <div class="game-details">
                                    <h3 class="game-title"><?= Html::encode($request->gameName) ?></h3>
                                    <div class="game-meta">
                                        <span class="meta-item">
                                            <i class="fas fa-calendar"></i>
                                            <?= $request->sessionDate ?>
                                        </span>
                                        <span class="meta-item">
                                            <i class="fas fa-clock"></i>
                                            <?= $request->sessionTime ?>
                                        </span>
                                        <span class="meta-item">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <?= Html::encode($request->sessionAddress) ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="request-status">
                                <?php
                                $statusLabels = [
                                    'новая' => ['Новая', 'warning'],
                                    'одобрена' => ['Одобрена', 'success'],
                                    'завершена' => ['Завершена', 'info'],
                                    'отменена' => ['Отменена', 'danger'],
                                ];
                                $status = $statusLabels[$request->status] ?? [$request->status, 'secondary'];
                                ?>
                                <span class="status-badge status-<?= $status[1] ?>">
                                    <i class="fas fa-circle"></i>
                                    <?= $status[0] ?>
                                </span>
                            </div>
                        </div>

                        <div class="request-card-body">
                            <div class="request-details-grid">
                                <div class="detail-item">
                                    <span class="detail-label">Номер заявки</span>
                                    <span class="detail-value">#<?= $request->id ?></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Количество игроков</span>
                                    <span class="detail-value"><?= $request->player_count ?> чел.</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Способ оплаты</span>
                                    <span class="detail-value"><?= $request->getPaymentMethodLabel() ?></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Стоимость</span>
                                    <span class="detail-value price"><?= number_format($request->total_price, 0, '', ' ') ?> ₽</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Дата заявки</span>
                                    <span class="detail-value"><?= date('d.m.Y H:i', $request->created_at) ?></span>
                                </div>
                            </div>

                            <?php if ($request->admin_comment): ?>
                                <div class="admin-comment">
                                    <i class="fas fa-comment-dots"></i>
                                    <div class="comment-content">
                                        <strong>Комментарий администратора:</strong>
                                        <p><?= Html::encode($request->admin_comment) ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if ($request->status == 'одобрена'): ?>
                            <div class="request-card-footer">
                                <button class="btn btn-outline-danger btn-sm" onclick="alert('Функция отмены заявки будет доступна позже')">
                                    <i class="fas fa-times"></i>
                                    Отменить заявку
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.my-requests-page {
    padding-bottom: 60px;
}

.requests-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 60px 0;
    margin-bottom: 40px;
    border-radius: 0 0 50px 50px;
    color: white;
    text-align: center;
}

.requests-title {
    font-size: 42px;
    font-weight: 800;
    margin-bottom: 15px;
}

.requests-subtitle {
    font-size: 18px;
    opacity: 0.95;
    max-width: 600px;
    margin: 0 auto;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 80px 20px;
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.05);
}

.empty-state-icon {
    width: 120px;
    height: 120px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 30px;
    font-size: 50px;
    color: #667eea;
}

.empty-state h2 {
    font-size: 28px;
    color: #333;
    margin-bottom: 15px;
}

.empty-state p {
    font-size: 16px;
    color: #666;
    margin-bottom: 30px;
}

.empty-state-actions {
    display: flex;
    gap: 15px;
    justify-content: center;
}

/* Timeline */
.requests-timeline {
    display: flex;
    flex-direction: column;
    gap: 25px;
}

.request-card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    overflow: hidden;
    transition: all 0.3s;
    border-left: 4px solid transparent;
}

.request-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
}

.request-card.новая {
    border-left-color: #ffc107;
}

.request-card.одобрена {
    border-left-color: #28a745;
}

.request-card.завершена {
    border-left-color: #17a2b8;
}

.request-card.отменена {
    border-left-color: #dc3545;
}

.request-card-header {
    padding: 25px;
    border-bottom: 1px solid #f0f0f0;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    background: linear-gradient(135deg, #667eea02 0%, #764ba202 100%);
}

.request-game-info {
    display: flex;
    gap: 20px;
}

.game-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    color: #667eea;
}

.game-details {
    flex: 1;
}

.game-title {
    font-size: 20px;
    font-weight: 700;
    color: #333;
    margin: 0 0 10px;
}

.game-meta {
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 6px;
    color: #666;
    font-size: 14px;
}

.meta-item i {
    color: #667eea;
}

/* Status Badge */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border-radius: 50px;
    font-size: 13px;
    font-weight: 600;
}

.status-badge i {
    font-size: 10px;
}

.status-warning {
    background: #fff3cd;
    color: #856404;
}

.status-success {
    background: #d4edda;
    color: #155724;
}

.status-info {
    background: #d1ecf1;
    color: #0c5460;
}

.status-danger {
    background: #f8d7da;
    color: #721c24;
}

.status-secondary {
    background: #e2e3e5;
    color: #383d41;
}

/* Request Body */
.request-card-body {
    padding: 25px;
}

.request-details-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.detail-item {
    display: flex;
    flex-direction: column;
    gap: 5px;
}

.detail-label {
    font-size: 12px;
    color: #999;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.detail-value {
    font-size: 16px;
    font-weight: 600;
    color: #333;
}

.detail-value.price {
    color: #28a745;
    font-size: 18px;
}

/* Admin Comment */
.admin-comment {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 20px;
    margin-top: 20px;
    display: flex;
    gap: 15px;
    border-left: 3px solid #667eea;
}

.admin-comment i {
    color: #667eea;
    font-size: 20px;
}

.comment-content {
    flex: 1;
}

.comment-content strong {
    display: block;
    margin-bottom: 8px;
    color: #333;
    font-size: 14px;
}

.comment-content p {
    margin: 0;
    color: #666;
    line-height: 1.6;
}

/* Footer */
.request-card-footer {
    padding: 20px 25px;
    background: #f8f9fa;
    border-top: 1px solid #f0f0f0;
    display: flex;
    justify-content: flex-end;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 24px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    border-radius: 12px;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-sm {
    padding: 8px 16px;
    font-size: 13px;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
}

.btn-outline {
    background: transparent;
    border: 2px solid #667eea;
    color: #667eea;
}

.btn-outline:hover {
    background: #667eea;
    color: white;
}

.btn-outline-danger {
    background: transparent;
    border: 2px solid #dc3545;
    color: #dc3545;
}

.btn-outline-danger:hover {
    background: #dc3545;
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .requests-header {
        padding: 40px 0;
    }
    
    .requests-title {
        font-size: 28px;
    }
    
    .request-card-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .request-game-info {
        width: 100%;
    }
    
    .game-meta {
        flex-direction: column;
        gap: 8px;
    }
    
    .empty-state-actions {
        flex-direction: column;
        padding: 0 20px;
    }
    
    .request-details-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .requests-title {
        font-size: 24px;
    }
    
    .game-icon {
        width: 50px;
        height: 50px;
        font-size: 24px;
    }
    
    .game-title {
        font-size: 18px;
    }
}
</style>