<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Личный кабинет';
?>

<div class="profile-page">
    <!-- Приветственный баннер -->
    <div class="profile-header">
        <div class="container">
            <div class="profile-header-content">
                <div class="profile-avatar">
                    <div class="avatar-circle">
                        <span><?= strtoupper(mb_substr($user->full_name, 0, 1)) ?></span>
                    </div>
                </div>
                <div class="profile-info">
                    <h1 class="profile-name"><?= Html::encode($user->full_name) ?></h1>
                    <div class="profile-status">
                        <span class="status-badge">
                            <i class="fas fa-shield-alt"></i>
                            Игрок
                        </span>
                        <span class="member-since">
                            <i class="fas fa-calendar-alt"></i>
                            С нами с <?= date('d.m.Y', $user->created_at) ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="profile-grid">
            <!-- Левая колонка - Контактная информация -->
            <div class="profile-sidebar">
                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-address-card"></i> Контактная информация</h3>
                    </div>
                    <div class="card-body">
                        <div class="info-group">
                            <div class="info-label">
                                <i class="fas fa-user"></i>
                                <span>ФИО</span>
                            </div>
                            <div class="info-value"><?= Html::encode($user->full_name) ?></div>
                        </div>
                        
                        <div class="info-group">
                            <div class="info-label">
                                <i class="fas fa-phone"></i>
                                <span>Телефон</span>
                            </div>
                            <div class="info-value"><?= Html::encode($user->phone) ?></div>
                        </div>
                        
                        <div class="info-group">
                            <div class="info-label">
                                <i class="fas fa-envelope"></i>
                                <span>Email</span>
                            </div>
                            <div class="info-value"><?= Html::encode($user->email) ?></div>
                        </div>
                        
                        <div class="info-group">
                            <div class="info-label">
                                <i class="fas fa-trophy"></i>
                                <span>Статус</span>
                            </div>
                            <div class="info-value">
                                <span class="level-badge">Новичок</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn-outline-primary btn-block" onclick="alert('Редактирование профиля будет доступно позже')">
                            <i class="fas fa-edit"></i>
                            Редактировать профиль
                        </button>
                    </div>
                </div>

                <!-- Статистика -->
                <div class="card stats-card">
                    <div class="card-header">
                        <h3><i class="fas fa-chart-bar"></i> Моя статистика</h3>
                    </div>
                    <div class="card-body">
                        <div class="stats-grid">
                            <div class="stat-item">
                                <div class="stat-icon">
                                    <i class="fas fa-ticket-alt"></i>
                                </div>
                                <div class="stat-info">
                                    <span class="stat-value">0</span>
                                    <span class="stat-label">Заявок</span>
                                </div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-icon">
                                    <i class="fas fa-gamepad"></i>
                                </div>
                                <div class="stat-info">
                                    <span class="stat-value">0</span>
                                    <span class="stat-label">Игр</span>
                                </div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-icon">
                                    <i class="fas fa-star"></i>
                                </div>
                                <div class="stat-info">
                                    <span class="stat-value">0</span>
                                    <span class="stat-label">Отзывов</span>
                                </div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="stat-info">
                                    <span class="stat-value">0</span>
                                    <span class="stat-label">Друзей</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Правая колонка - Активность -->
            <div class="profile-main">
                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-clock"></i> Ближайшие игры</h3>
                        <a href="#" class="btn btn-sm btn-primary" onclick="alert('Скоро здесь появится расписание игр')">
                            <i class="fas fa-plus"></i>
                            Записаться
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="empty-state">
                            <div class="empty-state-icon">
                                <i class="fas fa-calendar-day"></i>
                            </div>
                            <h4>У вас нет запланированных игр</h4>
                            <p>Самое время выбрать игру и записаться!</p>
                            <a href="#" class="btn btn-primary" onclick="alert('Скоро здесь появится каталог игр')">
                                <i class="fas fa-search"></i>
                                Найти игру
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-history"></i> История игр</h3>
                    </div>
                    <div class="card-body">
                        <div class="empty-state small">
                            <div class="empty-state-icon">
                                <i class="fas fa-dice"></i>
                            </div>
                            <p>У вас пока нет сыгранных игр</p>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-star"></i> Мои отзывы</h3>
                    </div>
                    <div class="card-body">
                        <div class="empty-state small">
                            <div class="empty-state-icon">
                                <i class="fas fa-comment"></i>
                            </div>
                            <p>Вы еще не оставляли отзывы</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.profile-page {
    min-height: calc(100vh - 300px);
    padding-bottom: 60px;
}

/* Profile Header */
.profile-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 60px 0 100px;
    margin-bottom: -70px;
    position: relative;
    overflow: hidden;
    border-radius: 0 0 50px 50px;
}

.profile-header:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><rect x="0" y="0" width="60" height="60" fill="none"/><circle cx="30" cy="30" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
    opacity: 0.5;
}

.profile-header-content {
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    gap: 30px;
    color: white;
}

.avatar-circle {
    width: 120px;
    height: 120px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 4px solid rgba(255, 255, 255, 0.5);
    backdrop-filter: blur(10px);
}

.avatar-circle span {
    font-size: 48px;
    font-weight: 700;
    color: white;
}

.profile-name {
    font-size: 36px;
    font-weight: 700;
    margin: 0 0 10px;
    color: white;
}

.profile-status {
    display: flex;
    gap: 20px;
    align-items: center;
}

.status-badge {
    background: rgba(255, 255, 255, 0.2);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    backdrop-filter: blur(10px);
}

.member-since {
    font-size: 14px;
    opacity: 0.9;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

/* Profile Grid */
.profile-grid {
    display: grid;
    grid-template-columns: 380px 1fr;
    gap: 30px;
    position: relative;
    z-index: 2;
}

/* Cards */
.card {
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.05);
    overflow: hidden;
    margin-bottom: 30px;
}

.card-header {
    padding: 20px 25px;
    border-bottom: 1px solid #e0e0e0;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.card-header h3 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
    color: #333;
    display: flex;
    align-items: center;
    gap: 10px;
}

.card-header h3 i {
    color: #667eea;
}

.card-body {
    padding: 25px;
}

.card-footer {
    padding: 20px 25px;
    border-top: 1px solid #e0e0e0;
    background: #f8f9fa;
}

/* Info Groups */
.info-group {
    display: flex;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid #e0e0e0;
}

.info-group:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.info-label {
    width: 100px;
    display: flex;
    align-items: center;
    gap: 10px;
    color: #666;
    font-size: 14px;
}

.info-label i {
    width: 20px;
    color: #667eea;
}

.info-value {
    flex: 1;
    color: #333;
    font-weight: 500;
}

.level-badge {
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    color: #667eea;
    padding: 5px 15px;
    border-radius: 50px;
    font-size: 13px;
    font-weight: 600;
    display: inline-block;
}

/* Stats */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
}

.stat-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 15px;
    transition: all 0.3s;
}

.stat-item:hover {
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    transform: translateY(-2px);
}

.stat-icon {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #667eea;
    font-size: 20px;
}

.stat-info {
    display: flex;
    flex-direction: column;
}

.stat-value {
    font-size: 24px;
    font-weight: 700;
    color: #333;
}

.stat-label {
    font-size: 13px;
    color: #666;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 40px 20px;
}

.empty-state.small {
    padding: 30px 20px;
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    font-size: 30px;
    color: #667eea;
}

.empty-state h4 {
    font-size: 20px;
    color: #333;
    margin-bottom: 10px;
}

.empty-state p {
    color: #666;
    margin-bottom: 20px;
}

.empty-state.small .empty-state-icon {
    width: 60px;
    height: 60px;
    font-size: 24px;
}

.empty-state.small p {
    margin-bottom: 0;
    font-size: 14px;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 10px 20px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    border-radius: 12px;
    transition: all 0.3s;
    border: none;
    cursor: pointer;
}

.btn-sm {
    padding: 8px 16px;
    font-size: 13px;
}

.btn-block {
    display: block;
    width: 100%;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.btn-outline-primary {
    background: transparent;
    color: #667eea;
    border: 2px solid #667eea;
}

.btn-outline-primary:hover {
    background: #667eea;
    color: white;
}

/* Responsive */
@media (max-width: 992px) {
    .profile-grid {
        grid-template-columns: 1fr;
    }
    
    .profile-header-content {
        flex-direction: column;
        text-align: center;
    }
    
    .profile-status {
        justify-content: center;
    }
    
    .profile-name {
        font-size: 28px;
    }
}

@media (max-width: 768px) {
    .profile-header {
        padding: 40px 0 80px;
    }
    
    .avatar-circle {
        width: 100px;
        height: 100px;
    }
    
    .avatar-circle span {
        font-size: 40px;
    }
    
    .profile-status {
        flex-direction: column;
        gap: 10px;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .card-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
}

@media (max-width: 480px) {
    .profile-name {
        font-size: 24px;
    }
    
    .info-group {
        flex-direction: column;
        gap: 10px;
    }
    
    .info-label {
        width: 100%;
    }
}
</style>